/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeetingMgrController.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "ObjCHelpers.h"
#import "ObjcWrapperCache.h"
#import "CSISecureString.h"
#import <Foundation/NSDate.h>
#import "ObjectFoundry.h"
#import <objc/runtime.h>

#import "JCFUnifiedBusinessObject.h"
#import "JCFMeetingMgrController.h"
#import "JCFMeetingCallback.h"
#include "csfunified/services/interface/MailServiceType_enum.h"

//cpp interface
#include "csfunified/services/interface/MeetingMgrController.h" 



NSString * const JCFMeetingMgrControllerOnlineSwitchDidChangeNotification = @"JCFMeetingMgrControllerOnlineSwitchDidChangeNotification";
NSString * const JCFMeetingMgrControllerOfflineSwitchDidChangeNotification = @"JCFMeetingMgrControllerOfflineSwitchDidChangeNotification";

#include <map>

typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> MeetingMgrControllerPtr;
typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrControllerObserver> MeetingMgrControllerObserverPtr;

typedef SMART_PTR_NS::weak_ptr<CSFUnified::MeetingMgrController> MeetingMgrControllerWPtr;
typedef std::owner_less<MeetingMgrControllerWPtr> wp_less;
typedef std::map<MeetingMgrControllerWPtr, JCFMeetingMgrController*, wp_less> MeetingMgrControllerCache;
static MeetingMgrControllerCache sCache;

@interface JCFMeetingMgrController ()

@property (nonatomic, readwrite, assign) struct MeetingMgrControllerOpaque *cpp;

-(id)initWithMeetingMgrControllerPtr:(MeetingMgrControllerPtr)meetingMgrController;

@end

#include "JCFMeetingMgrControllerObserver.h"

struct MeetingMgrControllerOpaque
{
	
	MeetingMgrControllerOpaque(JCFMeetingMgrController* ObjcOwner, MeetingMgrControllerPtr meetingMgrController) 
	:mMeetingMgrController(meetingMgrController),
	mMeetingMgrControllerObserver(new JCFMeetingMgrControllerObserver(ObjcOwner))
	{
		mMeetingMgrController->addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingMgrControllerObserver>(mMeetingMgrControllerObserver));
	};
	
	~MeetingMgrControllerOpaque() 
	{
		mMeetingMgrController->removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingMgrControllerObserver>(mMeetingMgrControllerObserver));
	};
	
	MeetingMgrControllerPtr mMeetingMgrController;
	
private:
	MeetingMgrControllerObserverPtr mMeetingMgrControllerObserver;
};

@implementation JCFMeetingMgrController

@synthesize cpp = mMeetingMgrControllerCpp;

#pragma mark Base Unified Business Object Properties





-(BOOL) onlineSwitch
{
    return self.cpp->mMeetingMgrController->getOnlineSwitch();
}


-(BOOL) offlineSwitch
{
    return self.cpp->mMeetingMgrController->getOfflineSwitch();
}




#pragma mark Constructors

-(JCFMeetingMgrController*) initWithMeetingMgrControllerPtr:(MeetingMgrControllerPtr)meetingMgrController
{
	@synchronized([self class])
	{
		MeetingMgrControllerWPtr wp(meetingMgrController);
		MeetingMgrControllerCache::const_iterator iter = sCache.find(wp);
		if (iter != sCache.end())
		{
			[self release];
			self = [(*iter).second retain];
		}
		else
		{
			self = [super initSuperWithUnifiedBusinessObjectPtr : meetingMgrController];
			if (self != nil)
			{
				if ([self class] == [JCFMeetingMgrController class])
				{
					if (meetingMgrController != NULL)
					{
						self.cpp = new MeetingMgrControllerOpaque(self, meetingMgrController);
						sCache[wp] = self;
					}
					else
					{
						[self release];
						self = nil;
					}
				}
			}
		}
	}

	return self;
}

-(JCFMeetingMgrController*) initSuperWithMeetingMgrControllerPtr:(MeetingMgrControllerPtr)meetingMgrController
{
	self = [super initSuperWithUnifiedBusinessObjectPtr : meetingMgrController];

	if (self != nil)
	{
		if ([self class] == [JCFMeetingMgrController class])
		{
			if (meetingMgrController == NULL)
			{
				[self release];
				self = nil;
			}
		}
	}
	return self;
}

-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr
{
	MeetingMgrControllerPtr meetingMgrController = SMART_PTR_NS::dynamic_pointer_cast<CSFUnified::MeetingMgrController>(cppPtr);
	self = [self initWithMeetingMgrControllerPtr: meetingMgrController ];
	return self;
}

-(JCFMeetingMgrController*) init
{
    NSAssert(NO, @"init with initWithMeetingMgrControllerPtr:");
    [self release];
    self = nil;
	return nil;
}

+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey {
	
	if([theKey isEqualToString:@"onlineSwitch"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"offlineSwitch"])
	{
		return NO;
	}
	return [super automaticallyNotifiesObserversForKey:theKey];
}

+ (BOOL)accessInstanceVariablesDirectly
{
	return NO;
}

- (void)willChangeValueForKey:(NSString *)key
{
	kvoUpdate = YES;

	[super willChangeValueForKey:key];
}

- (void)didChangeValueForKey:(NSString *)key
{
	kvoUpdate = NO;
	[super didChangeValueForKey:key];
}

- (void)addObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
	
	if([keyPath hasPrefix:@"onlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOnlineSwitch, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"offlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOfflineSwitch, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}

	[super addObserver:observer forKeyPath:keyPath options:options context:context];
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath context:(void *)context
{
	[super removeObserver:observer forKeyPath:keyPath context:context];

	
	if([keyPath hasPrefix:@"onlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOnlineSwitch, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"offlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOfflineSwitch, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath
{
	[super removeObserver:observer forKeyPath:keyPath];

	
	if([keyPath hasPrefix:@"onlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOnlineSwitch, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"offlineSwitch"])
	{
		objc_setAssociatedObject(observer, &mOfflineSwitch, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

-(void)dealloc
{
	@synchronized([self class])
	{
		if (self.cpp != NULL)
		{
			MeetingMgrControllerWPtr wp(self.cpp->mMeetingMgrController);
			sCache.erase(wp);

	  		delete self.cpp;
  			self.cpp = NULL;
	  	}
	}

  	[super dealloc];
}

-(MeetingMgrControllerPtr) getMeetingMgrControllerPtr
{
	return self.cpp->mMeetingMgrController;
}


-(void) registerMeetingCallback:(id<JCFMeetingCallbackDelegate>)meetingCallback 
{
JCFMeetingCallback *cbmeetingCallback;

	JCFMeetingCallback *testmeetingCallback = [[[JCFMeetingCallback alloc] init] autorelease];
	testmeetingCallback.delegate = meetingCallback;
	if([ObjcWrapperCache isCallbackCached:testmeetingCallback])
	{
		cbmeetingCallback = (JCFMeetingCallback*)[ObjcWrapperCache getCachedCallback:testmeetingCallback];
		[cbmeetingCallback retain];
	}
	else
	{
		cbmeetingCallback = [[JCFMeetingCallback alloc] init];
		cbmeetingCallback.delegate = meetingCallback;
		[ObjcWrapperCache cacheCallback:cbmeetingCallback];
	}
	testmeetingCallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallbackCpp;

	
	meetingCallbackCpp = cbmeetingCallback.getCppCallback;
	self.cpp->mMeetingMgrController->registerMeetingCallback(meetingCallbackCpp);
	[cbmeetingCallback release];
}

-(void) unregisterMeetingCallback:(id<JCFMeetingCallbackDelegate>)meetingCallback 
{
JCFMeetingCallback *cbmeetingCallback;

	JCFMeetingCallback *testmeetingCallback = [[[JCFMeetingCallback alloc] init] autorelease];
	testmeetingCallback.delegate = meetingCallback;
	if([ObjcWrapperCache isCallbackCached:testmeetingCallback])
	{
		cbmeetingCallback = (JCFMeetingCallback*)[ObjcWrapperCache getCachedCallback:testmeetingCallback];
		[cbmeetingCallback retain];
	}
	else
	{
		cbmeetingCallback = [[JCFMeetingCallback alloc] init];
		cbmeetingCallback.delegate = meetingCallback;
		[ObjcWrapperCache cacheCallback:cbmeetingCallback];
	}
	testmeetingCallback.delegate = nil;
	SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallbackCpp;

	
	meetingCallbackCpp = cbmeetingCallback.getCppCallback;
	self.cpp->mMeetingMgrController->unregisterMeetingCallback(meetingCallbackCpp);
	[cbmeetingCallback release];
}

-(BOOL) isMeetingInProgress:(NSString*)meetingID 
{

	std::string meetingIDCpp;

	bool resultCpp;
	
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	resultCpp = self.cpp->mMeetingMgrController->isMeetingInProgress(meetingIDCpp);
	return resultCpp;
}

-(void) getCMRInfo:(NSString*)meetingKeyList 
{

	std::string meetingKeyListCpp;

	
	meetingKeyListCpp = JCFStdStringForNSString(meetingKeyList);
	self.cpp->mMeetingMgrController->getCMRInfo(meetingKeyListCpp);
}

-(unsigned long) listMeetings:(int)year month:(int)month day:(int)day 
{

	int yearCpp;
	int monthCpp;
	int dayCpp;

	unsigned long resultCpp;
	
	yearCpp = year;
	monthCpp = month;
	dayCpp = day;
	resultCpp = self.cpp->mMeetingMgrController->listMeetings(yearCpp, monthCpp, dayCpp);
	return resultCpp;
}

-(unsigned long) refreshMeetings
{


	unsigned long resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->refreshMeetings();
	return resultCpp;
}

-(BOOL) todayChanged:(BOOL)bForceChanged 
{

	bool bForceChangedCpp;

	bool resultCpp;
	
	bForceChangedCpp = bForceChanged;
	resultCpp = self.cpp->mMeetingMgrController->todayChanged(bForceChangedCpp);
	return resultCpp;
}

-(unsigned long) getMeetingDetail:(NSString*)meetingID 
{

	std::string meetingIDCpp;

	unsigned long resultCpp;
	
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	resultCpp = self.cpp->mMeetingMgrController->getMeetingDetail(meetingIDCpp);
	return resultCpp;
}

-(unsigned long) viewMeetingById:(NSString*)meetingID 
{

	std::string meetingIDCpp;

	unsigned long resultCpp;
	
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	resultCpp = self.cpp->mMeetingMgrController->viewMeetingById(meetingIDCpp);
	return resultCpp;
}

-(BOOL) isInMeeting
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->isInMeeting();
	return resultCpp;
}

-(BOOL) canStartMeeting
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->canStartMeeting();
	return resultCpp;
}

-(BOOL) canJoinMeeting
{


	bool resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->canJoinMeeting();
	return resultCpp;
}

-(unsigned long) launchMeetingById:(NSString*)meetingID 
{

	std::string meetingIDCpp;

	unsigned long resultCpp;
	
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	resultCpp = self.cpp->mMeetingMgrController->launchMeetingById(meetingIDCpp);
	return resultCpp;
}

-(BOOL) startInstantMeeting:(NSString*)meetingName vecInviteList:(NSArray*)vecInviteList 
{

	std::string meetingNameCpp;
	SMART_PTR_NS::shared_ptr<std::vector<std::string> > vecInviteListCpp(new std::vector<std::string>);

	bool resultCpp;
	
	meetingNameCpp = JCFStdStringForNSString(meetingName);
	NSUInteger i, number;
	number = [vecInviteList count];
	for (i = 0; i < number; i++)
	{
		vecInviteListCpp->push_back(JCFStdStringForNSString([vecInviteList objectAtIndex:i]));
	}
	resultCpp = self.cpp->mMeetingMgrController->startInstantMeeting(meetingNameCpp, vecInviteListCpp);
	return resultCpp;
}

-(BOOL) inviteToInstantMeeting:(NSString*)attendeeName 
{

	std::string attendeeNameCpp;

	bool resultCpp;
	
	attendeeNameCpp = JCFStdStringForNSString(attendeeName);
	resultCpp = self.cpp->mMeetingMgrController->inviteToInstantMeeting(attendeeNameCpp);
	return resultCpp;
}

-(BOOL) acceptInstantMeeting:(NSString*)sessioName 
{

	std::string sessioNameCpp;

	bool resultCpp;
	
	sessioNameCpp = JCFStdStringForNSString(sessioName);
	resultCpp = self.cpp->mMeetingMgrController->acceptInstantMeeting(sessioNameCpp);
	return resultCpp;
}

-(BOOL) declineInstantMeeting:(NSString*)sessioName 
{

	std::string sessioNameCpp;

	bool resultCpp;
	
	sessioNameCpp = JCFStdStringForNSString(sessioName);
	resultCpp = self.cpp->mMeetingMgrController->declineInstantMeeting(sessioNameCpp);
	return resultCpp;
}

-(void) editInstantMeetingSetting
{


	
	self.cpp->mMeetingMgrController->editInstantMeetingSetting();
}

-(unsigned long) sendEmail:(NSString*)tos subject:(NSString*)subject body:(NSString*)body meetingKey:(NSString*)meetingKey 
{

	std::string tosCpp;
	std::string subjectCpp;
	std::string bodyCpp;
	std::string meetingKeyCpp;

	unsigned long resultCpp;
	
	tosCpp = JCFStdStringForNSString(tos);
	subjectCpp = JCFStdStringForNSString(subject);
	bodyCpp = JCFStdStringForNSString(body);
	meetingKeyCpp = JCFStdStringForNSString(meetingKey);
	resultCpp = self.cpp->mMeetingMgrController->sendEmail(tosCpp, subjectCpp, bodyCpp, meetingKeyCpp);
	return resultCpp;
}

-(int) getInstantMeetingLastErrCode
{


	int resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->getInstantMeetingLastErrCode();
	return resultCpp;
}

-(BOOL) startJoinMeetingByUrl:(NSString*)strURL 
{

	std::string strURLCpp;

	bool resultCpp;
	
	strURLCpp = JCFStdStringForNSString(strURL);
	resultCpp = self.cpp->mMeetingMgrController->startJoinMeetingByUrl(strURLCpp);
	return resultCpp;
}

-(NSString*) sendMeetingInvitation:(NSString*)attendees meetingID:(NSString*)meetingID msg:(NSString*)msg 
{

	std::string attendeesCpp;
	std::string meetingIDCpp;
	std::string msgCpp;

	std::string resultCpp;
	
	attendeesCpp = JCFStdStringForNSString(attendees);
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	msgCpp = JCFStdStringForNSString(msg);
	resultCpp = self.cpp->mMeetingMgrController->sendMeetingInvitation(attendeesCpp, meetingIDCpp, msgCpp);
	NSString *resultObjc = JCFNSStringForStdString(resultCpp);
	return resultObjc;
}

-(void) setMeetingReminderEnable:(BOOL)isEnable 
{

	bool isEnableCpp;

	
	isEnableCpp = isEnable;
	self.cpp->mMeetingMgrController->setMeetingReminderEnable(isEnableCpp);
}

-(NSString*) sendMeetingReminder:(NSString*)attendees meetingID:(NSString*)meetingID msg:(NSString*)msg 
{

	std::string attendeesCpp;
	std::string meetingIDCpp;
	std::string msgCpp;

	std::string resultCpp;
	
	attendeesCpp = JCFStdStringForNSString(attendees);
	meetingIDCpp = JCFStdStringForNSString(meetingID);
	msgCpp = JCFStdStringForNSString(msg);
	resultCpp = self.cpp->mMeetingMgrController->sendMeetingReminder(attendeesCpp, meetingIDCpp, msgCpp);
	NSString *resultObjc = JCFNSStringForStdString(resultCpp);
	return resultObjc;
}

-(JCFMailServiceType) getCurrentMailType
{


	CSFUnified::MailServiceTypeEnum::MailServiceType resultCpp;
	
	resultCpp = self.cpp->mMeetingMgrController->getCurrentMailType();
	return (JCFMailServiceType)resultCpp;
}

-(BOOL) openMeetingDetailPage:(NSString*)strURL 
{

	std::string strURLCpp;

	bool resultCpp;
	
	strURLCpp = JCFStdStringForNSString(strURL);
	resultCpp = self.cpp->mMeetingMgrController->openMeetingDetailPage(strURLCpp);
	return resultCpp;
}



@end